/****** Object:  StoredProcedure [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_APURACAO_EXECUTE_ALL]    Script Date: 02/10/2014 18:47:24 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_APURACAO_EXECUTE_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_APURACAO_EXECUTE_ALL]
GO 
-- EXECUTE  
CREATE PROCEDURE [dbo].[P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_APURACAO_EXECUTE_ALL]  AS

SET NOCOUNT ON;
PRINT 'Processamento de contratos de ressarcimento de promocoes' 
DECLARE @CD_CTR_GRUPO AS INT
DECLARE @FLAG_TIPO_GRUPO AS INT

DECLARE @ErrorMessage VARCHAR(4000)=ERROR_MESSAGE();  
	   DECLARE @ErrorSeverity INT=ERROR_SEVERITY();  
	   DECLARE @ErrorState INT=ERROR_STATE();  


DECLARE CContratosRessarcimento CURSOR FAST_FORWARD FOR     
	SELECT
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO,
		CG_FND_VERBA_NOTA_CREDITO_GRUPO.FLAG_TIPO_GRUPO
	FROM
		CG_FND_VERBA_NOTA_CREDITO_GRUPO
		INNER JOIN CG_FND_VERBA_NOTA_CREDITO_GRUPO_LIB ON
			CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_EMP = CG_FND_VERBA_NOTA_CREDITO_GRUPO_LIB.CD_EMP
			AND CG_FND_VERBA_NOTA_CREDITO_GRUPO.CD_CTR_GRUPO = CG_FND_VERBA_NOTA_CREDITO_GRUPO_LIB.CD_CTR_GRUPO
	WHERE
		CONVERT(CHAR(10),GETDATE(),112) BETWEEN CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_INI AND CG_FND_VERBA_NOTA_CREDITO_GRUPO.DT_FIM

OPEN CContratosRessarcimento
FETCH NEXT FROM CContratosRessarcimento INTO @CD_CTR_GRUPO,@FLAG_TIPO_GRUPO

begin try

	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT	'  Analisando contrato ' + convert(varchar(15), @CD_CTR_GRUPO) + 
				' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
		
			IF @FLAG_TIPO_GRUPO=1
			BEGIN
				PRINT 'Selling Out'
				EXECUTE dbo.P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_APURACAO  @CD_CTR_GRUPO
			END

			FETCH NEXT FROM CContratosRessarcimento INTO @CD_CTR_GRUPO,@FLAG_TIPO_GRUPO
		END

	CLOSE CContratosRessarcimento
	DEALLOCATE CContratosRessarcimento

	PRINT 'Chamado a procedure para criao dos contratos de verba fixa vinculados.'
	EXEC P_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CRIACAO_CONTRATO_VERBA_EXECUTE_ALL

	PRINT 'Concluido.'
end try
begin Catch
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
    SELECT ERROR_NUMBER() AS numero,
            @ErrorSeverity AS severidade,
            @ErrorState AS estado,
            ERROR_PROCEDURE() AS rotina,
            ERROR_LINE() AS linha,
            @ErrorMessage AS mensagem,
            GETDATE() AS dtErro;	   
	RAISERROR (@ErrorMessage, @ErrorSeverity,@ErrorState );
end Catch